/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tiled.core.Map;
import tiled.core.TileSet;
import tiled.mapeditor.Resources;
import tiled.mapeditor.dialogs.ImageColorDialog;
import tiled.mapeditor.dialogs.PropertiesDialog;
import tiled.mapeditor.util.cutter.BasicTileCutter;
import tiled.mapeditor.util.cutter.BorderTileCutter;
import tiled.mapeditor.util.cutter.TileCutter;
import tiled.mapeditor.widget.ColorButton;
import tiled.mapeditor.widget.IntegerSpinner;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class NewTilesetDialog
extends JDialog
implements ChangeListener {
    private final Map map;
    private TileSet newTileset;
    private IntegerSpinner tileWidth;
    private IntegerSpinner tileHeight;
    private IntegerSpinner tileSpacing;
    private IntegerSpinner tileMargin;
    private JTextField tilesetName;
    private JTextField tilebmpFile;
    private JLabel spacingLabel;
    private JLabel marginLabel;
    private JLabel tilebmpFileLabel;
    private JLabel cutterLabel;
    private JCheckBox tilebmpCheck;
    private JCheckBox transCheck;
    private JComboBox cutterBox;
    private JButton previewButton;
    private JButton browseButton;
    private JButton propsButton;
    private ColorButton colorButton;
    private String path;
    private Properties defaultSetProperties;
    private static final String DIALOG_TITLE = Resources.getString("dialog.newtileset.title");
    private static final String NAME_LABEL = Resources.getString("dialog.newtileset.name.label");
    private static final String TILE_WIDTH_LABEL = Resources.getString("dialog.newtileset.tilewidth.label");
    private static final String TILE_HEIGHT_LABEL = Resources.getString("dialog.newtileset.tileheight.label");
    private static final String TILE_SPACING_LABEL = Resources.getString("dialog.newtileset.tilespacing.label");
    private static final String TILE_MARGIN_LABEL = Resources.getString("dialog.newtileset.tilemargin.label");
    private static final String IMAGE_LABEL = Resources.getString("dialog.newtileset.image.label");
    private static final String UNTITLED_FILE = Resources.getString("general.file.untitled");
    private static final String TILESET_IMG_LABEL = Resources.getString("dialog.newtileset.tilesetimgref.label");
    private static final String USE_TRANS_COLOR_LABEL = Resources.getString("dialog.newtileset.usetransparentcolor.label");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String PREVIEW_BUTTON = Resources.getString("general.button.preview");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");
    private static final String BROWSE_BUTTON = Resources.getString("general.button.browse");
    private static final String FROM_TILESET_IMG_TITLE = Resources.getString("dialog.newtileset.fromtilesetimg.title");
    private static final String IMPORT_ERROR_MSG = Resources.getString("dialog.newtileset.import.error.message");
    private static final String IMG_LOAD_ERROR = Resources.getString("dialog.newtileset.imgload.error.message");
    private static final String COLOR_CHOOSE_ERROR_TITLE = Resources.getString("dialog.newtileset.colorchoose.error.title");
    private static final String PROPERTIES_TITLE = Resources.getString("dialog.properties.default.title");
    private static final String PROPERTIES_BUTTON = Resources.getString("dialog.newtileset.button.properties");

    public NewTilesetDialog(JFrame parent, Map map) {
        super(parent, DIALOG_TITLE, true);
        this.map = map;
        this.path = map.getFilename();
        this.defaultSetProperties = new Properties();
        this.init();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        JLabel nameLabel = new JLabel(NAME_LABEL);
        JLabel tileWidthLabel = new JLabel(TILE_WIDTH_LABEL);
        JLabel tileHeightLabel = new JLabel(TILE_HEIGHT_LABEL);
        this.spacingLabel = new JLabel(TILE_SPACING_LABEL);
        this.marginLabel = new JLabel(TILE_MARGIN_LABEL);
        this.tilebmpFileLabel = new JLabel(IMAGE_LABEL);
        this.cutterLabel = new JLabel("Tile Cutter: ");
        this.tilesetName = new JTextField(UNTITLED_FILE);
        this.tileWidth = new IntegerSpinner(this.map.getTileWidth(), 1, 1024);
        this.tileHeight = new IntegerSpinner(this.map.getTileHeight(), 1, 1024);
        this.tileSpacing = new IntegerSpinner(0, 0);
        this.tileMargin = new IntegerSpinner(0, 0);
        this.tilebmpFile = new JTextField(10);
        this.tilebmpFile.setEnabled(false);
        nameLabel.setLabelFor(this.tilesetName);
        tileWidthLabel.setLabelFor(this.tileWidth);
        tileHeightLabel.setLabelFor(this.tileHeight);
        this.spacingLabel.setLabelFor(this.tileSpacing);
        this.marginLabel.setLabelFor(this.tileMargin);
        this.tilebmpFileLabel.setLabelFor(this.tilebmpFile);
        tileWidthLabel.setEnabled(false);
        this.tileWidth.setEnabled(false);
        this.cutterBox = new JComboBox<String>(new String[]{"Basic", "Border"});
        this.cutterBox.setEditable(false);
        this.cutterBox.setEnabled(false);
        this.cutterLabel.setEnabled(false);
        this.tilebmpCheck = new JCheckBox(TILESET_IMG_LABEL, false);
        this.tilebmpCheck.addChangeListener(this);
        this.transCheck = new JCheckBox(USE_TRANS_COLOR_LABEL);
        this.transCheck.addChangeListener(this);
        JButton okButton = new JButton(OK_BUTTON);
        this.previewButton = new JButton(PREVIEW_BUTTON);
        JButton cancelButton = new JButton(CANCEL_BUTTON);
        this.browseButton = new JButton(BROWSE_BUTTON);
        this.propsButton = new JButton(PROPERTIES_BUTTON);
        this.colorButton = new ColorButton(new Color(255, 0, 255));
        JPanel tilebmpPathPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        tilebmpPathPanel.add((Component)this.tilebmpFile, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 5, 0, 0);
        tilebmpPathPanel.add((Component)this.browseButton, c);
        JPanel tileColorPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        tileColorPanel.add((Component)this.transCheck, c);
        c.gridx = 1;
        tileColorPanel.add(this.colorButton);
        VerticalStaticJPanel tilebmpPanel = new VerticalStaticJPanel();
        tilebmpPanel.setLayout(new GridBagLayout());
        tilebmpPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(FROM_TILESET_IMG_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.anchor = 13;
        c.fill = 2;
        c.gridwidth = 4;
        tilebmpPanel.add((Component)this.tilebmpCheck, c);
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(5, 0, 0, 5);
        c.fill = 0;
        tilebmpPanel.add((Component)this.tilebmpFileLabel, c);
        c.gridy = 2;
        tilebmpPanel.add((Component)this.spacingLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.gridwidth = 3;
        tilebmpPanel.add((Component)tilebmpPathPanel, c);
        c.gridwidth = 1;
        c.gridy = 2;
        tilebmpPanel.add((Component)this.tileSpacing, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 4;
        tilebmpPanel.add((Component)tileColorPanel, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 5, 0, 0);
        tilebmpPanel.add((Component)this.marginLabel, c);
        c.gridx = 3;
        c.weightx = 1.0;
        tilebmpPanel.add((Component)this.tileMargin, c);
        c.gridx = 1;
        c.gridwidth = 1;
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(cancelButton);
        VerticalStaticJPanel miscPropPanel = new VerticalStaticJPanel();
        miscPropPanel.setLayout(new GridBagLayout());
        miscPropPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 5);
        miscPropPanel.add((Component)nameLabel, c);
        c.gridy = 1;
        miscPropPanel.add((Component)tileWidthLabel, c);
        c.gridy = 2;
        miscPropPanel.add((Component)tileHeightLabel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        miscPropPanel.add((Component)this.tilesetName, c);
        c.gridy = 1;
        miscPropPanel.add((Component)this.tileWidth, c);
        c.gridy = 2;
        miscPropPanel.add((Component)this.tileHeight, c);
        c.gridy = 3;
        miscPropPanel.add((Component)this.propsButton, c);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(miscPropPanel);
        mainPanel.add(tilebmpPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(Box.createGlue());
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(okButton);
        this.setUseTileBitmap(this.tilebmpCheck.isSelected());
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewTilesetDialog.this.createSetAndDispose();
            }
        });
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("TilesetPreviewDialog");
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewTilesetDialog.this.dispose();
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser ch = new JFileChooser(NewTilesetDialog.this.path);
                int ret = ch.showOpenDialog(NewTilesetDialog.this);
                if (ret == 0) {
                    NewTilesetDialog.this.path = ch.getSelectedFile().getAbsolutePath();
                    NewTilesetDialog.this.tilebmpFile.setText(NewTilesetDialog.this.path);
                }
            }
        });
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewTilesetDialog.this.chooseColorFromImage();
            }
        });
        this.propsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog lpd = new PropertiesDialog(null, NewTilesetDialog.this.defaultSetProperties);
                lpd.setTitle(PROPERTIES_TITLE);
                lpd.getProps();
            }
        });
    }

    public TileSet create() {
        this.setVisible(true);
        return this.newTileset;
    }

    public TileCutter getCutter(int w, int h, int spacing, int margin) {
        String selectedItem = (String)this.cutterBox.getSelectedItem();
        if (selectedItem.equalsIgnoreCase("basic")) {
            return new BasicTileCutter(w, h, spacing, margin);
        }
        if (selectedItem.equalsIgnoreCase("border")) {
            return new BorderTileCutter();
        }
        return null;
    }

    private void createSetAndDispose() {
        this.newTileset = new TileSet();
        this.newTileset.setName(this.tilesetName.getText());
        this.newTileset.setDefaultProperties(this.defaultSetProperties);
        if (this.tilebmpCheck.isSelected()) {
            String file = this.tilebmpFile.getText();
            int spacing = this.tileSpacing.intValue();
            int margin = this.tileMargin.intValue();
            int width = this.tileWidth.intValue();
            int height = this.tileHeight.intValue();
            try {
                if (this.transCheck.isSelected()) {
                    Color color = this.colorButton.getColor();
                    this.newTileset.setTransparentColor(color);
                }
                this.newTileset.importTileBitmap(file, this.getCutter(width, height, spacing, margin));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), IMPORT_ERROR_MSG, 2);
            }
        }
        this.dispose();
    }

    private void chooseColorFromImage() {
        try {
            ImageColorDialog icd = new ImageColorDialog(ImageIO.read(new File(this.tilebmpFile.getText())));
            Color c = icd.showDialog();
            if (c != null) {
                this.colorButton.setColor(c);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getOwner(), IMG_LOAD_ERROR + " " + e.getLocalizedMessage(), COLOR_CHOOSE_ERROR_TITLE, 0);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.tilebmpCheck) {
            this.setUseTileBitmap(this.tilebmpCheck.isSelected());
        } else if (source == this.transCheck) {
            this.colorButton.setEnabled(this.tilebmpCheck.isSelected() && this.transCheck.isSelected());
        }
    }

    private void setUseTileBitmap(boolean value) {
        this.tilebmpFile.setEnabled(value);
        this.tilebmpFileLabel.setEnabled(value);
        this.browseButton.setEnabled(value);
        this.tileSpacing.setEnabled(value);
        this.tileMargin.setEnabled(value);
        this.spacingLabel.setEnabled(value);
        this.marginLabel.setEnabled(value);
        this.transCheck.setEnabled(value);
        this.colorButton.setEnabled(value && this.transCheck.isSelected());
        this.previewButton.setEnabled(value);
    }
}

